import pandas as pd  
import matplotlib.pyplot as plt  
import seaborn as sns  
   
# Load the dataset   
credit_customers = pd.read_csv("credit_customers.csv") 
   
# Distribution plot for employment status  
plt.figure(figsize=(10, 6))   
sns.countplot(x='employment', data=credit_customers, order=credit_customers['employment'].value_counts().index)   
plt.title("Employment Status Distribution")   
plt.xlabel("Employment Status")   
plt.ylabel("Frequency")   
plt.savefig('ref_result/countplot.png')  
plt.show()  
